#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include "C:\\WINDDK\\6000\\inc\\ddk\\hidclass.h"
#include <sysutils.hpp>

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
DWORD requiredSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
//---------------------------------------------------------
HANDLE  hidDeviceObject;
PHID_COLLECTION_INFORMATION collectionInformation;
DWORD lpBytesReturned = 0;
//---------------------------------------------------------
PHID_COLLECTION_INFORMATION getCollectionDescriptor()
{
   PHID_COLLECTION_INFORMATION descriptor;
   descriptor = new \
            HID_COLLECTION_INFORMATION[(sizeof(HID_COLLECTION_INFORMATION))];
   descriptor->DescriptorSize = sizeof(HID_COLLECTION_INFORMATION);
   DWORD lpBytesReturned=0;
   bool result;
   result = DeviceIoControl(hidDeviceObject, IOCTL_HID_GET_COLLECTION_INFORMATION,
               descriptor,descriptor->DescriptorSize, descriptor,
               descriptor->DescriptorSize, &lpBytesReturned, NULL);
   if(!result)
     releaseMemory(descriptor);
   return result ? descriptor : NULL;
}
//---------------------------------------------------------
int main()
{
   void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

   hHidLib = LoadLibrary("HID.DLL");
   if (!hHidLib)
     displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");

   if (!HidD_GetHidGuid){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
       FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);


   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            &requiredSize, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                  GENERIC_READ | GENERIC_READ,
                                  FILE_SHARE_READ | FILE_SHARE_WRITE,
                                  NULL, OPEN_EXISTING, 0, NULL );
       if(hidDeviceObject != INVALID_HANDLE_VALUE) {
          cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";

          PHID_COLLECTION_INFORMATION getCollectionDesc = \
                                      getCollectionDescriptor();
          if(getCollectionDesc) {
             printf("Zawartosc deskryptora\n");
             printf("DescriptorSize: %u\n",getCollectionDesc->DescriptorSize);
             printf("Polled:         %d\n",getCollectionDesc->Polled);
             printf("VendorID:       0x%x\n",getCollectionDesc->VendorID);
             printf("ProductID:      0x%x\n",getCollectionDesc->ProductID);
             printf("VersionNumber:  0x%x\n",getCollectionDesc->VersionNumber);
             getCollectionDesc = NULL;
          }
          Win32Check(CloseHandle(hidDeviceObject));
       }
       releaseMemory(deviceInterfaceDetailData);
    };//koniec while

   //Win32Check(CloseHandle(hidDeviceObject));
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

